package de.brightbyte.data.measure;

import java.util.Set;

/**
 * Tanimoto similarity measure for simple sets. 
 * The similarity is given by <tt>|A&cap;B| / |A&cup;B|</tt>. 
 * 
 * @param <T> The element type of the Sets to use with this TanimotoSetSimilarity measure.
 */
public class TanimotoSetSimilarity<T> implements Similarity<Set<T>> {

	public double similarity(Set<T> a, Set<T> b) {
		if (a==b || a.equals(b)) return 1;
		
		int union = a.size() + b.size();
		int overlap = 0;
		
		for (T x: a) {
			if (b.contains(x)) {
				union--;
				overlap++;
			}
		}
		
		return (double)overlap / (double)union;
	}

}
