package de.brightbyte.data.measure;

public class SimilarityMeasure<T> implements Measure<T> {

	protected Similarity<T> similarity; 
	protected T prototype;
	
	public SimilarityMeasure(Similarity<T> distance, T prototype) {
		super();
		this.similarity = distance;
		this.prototype = prototype;
	}

	public double measure(T obj) {
		return similarity.similarity(prototype, obj);
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((similarity == null) ? 0 : similarity.hashCode());
		result = PRIME * result + ((prototype == null) ? 0 : prototype.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final SimilarityMeasure other = (SimilarityMeasure) obj;
		if (similarity == null) {
			if (other.similarity != null)
				return false;
		} else if (!similarity.equals(other.similarity))
			return false;
		if (prototype == null) {
			if (other.prototype != null)
				return false;
		} else if (!prototype.equals(other.prototype))
			return false;
		return true;
	}

	
}
