package de.brightbyte.data.measure;


public class SimilarityAsDistance<T> implements Distance<T> {
	
	protected Similarity<T> similarity;
	protected double scale;
	
	public SimilarityAsDistance(Similarity<T> similarity) {
		this(similarity, 1);
	}

	public SimilarityAsDistance(Similarity<T> similarity, double scale) {
		if (similarity==null) throw new NullPointerException();
		this.similarity = similarity;
		this.scale = scale;
	}

	public double distance(T a, T b) {
		return scale / (similarity.similarity(a, b)+1);
	}

}
