package de.brightbyte.data.measure;

import java.util.Comparator;

public class MeasureComparator<T> implements Comparator<T> {
	protected Measure<T> measure;

	public MeasureComparator(Measure<T> measure) {
		super();
		this.measure = measure;
	}

	public int compare(T a, T b) {
		double d = measure.measure(a) - measure.measure(b);
		
		if (d>0) return (int)(d+1);
		else if (d<0) return (int)(d-1);
		else return 0;
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((measure == null) ? 0 : measure.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final MeasureComparator other = (MeasureComparator) obj;
		if (measure == null) {
			if (other.measure != null)
				return false;
		} else if (!measure.equals(other.measure))
			return false;
		return true;
	}
	
	
}
