package de.brightbyte.data.measure;

import junit.framework.TestCase;

public class LevenshteinDistanceTest extends TestCase {

	public void assertDistance(double expected, LevenshteinDistance levenshtein, String a, String b) {
		assertEquals("distance between "+a+" and "+b, expected, levenshtein.distance(a, b));
		assertEquals("distance between "+b+" and "+a, expected, levenshtein.distance(b, a));
	}
	
	public void testDistance_full_sensitive() {
		LevenshteinDistance fullSensitive = new LevenshteinDistance(true, 0);
		
		assertDistance(0, fullSensitive, "abcd", "abcd");
		
		assertDistance(1, fullSensitive, "abcd", "Abcd");
		assertDistance(1, fullSensitive, "abcd", "aBcd");
		assertDistance(1, fullSensitive, "abcd", "abCd");
		assertDistance(1, fullSensitive, "abcd", "abcD");

		assertDistance(1, fullSensitive, "abcd", "bcd");
		assertDistance(1, fullSensitive, "abcd", "acd");
		assertDistance(1, fullSensitive, "abcd", "abd");
		assertDistance(1, fullSensitive, "abcd", "abc");

		assertDistance(1, fullSensitive, "abcd", "xabcd");
		assertDistance(1, fullSensitive, "abcd", "axbcd");
		assertDistance(1, fullSensitive, "abcd", "abxcd");
		assertDistance(1, fullSensitive, "abcd", "abcxd");
		assertDistance(1, fullSensitive, "abcd", "abcdx");

		assertDistance(4, fullSensitive, "abcd", "");
		assertDistance(4, fullSensitive, "abcd", "ABCD");
		assertDistance(4, fullSensitive, "abcd", "abcdabcd");
	}

	public void testDistance_limited() {
		LevenshteinDistance fullSensitive = new LevenshteinDistance(true, 3);

		assertDistance(0, fullSensitive, "abcd", "abcd");
		assertDistance(1, fullSensitive, "abcd", "Abcd");
		
		assertDistance(3, fullSensitive, "12345", "x");
		assertDistance(3, fullSensitive, "abcd", "x");
		assertDistance(3, fullSensitive, "abcd", "a");
		assertDistance(3, fullSensitive, "abcd", "b");
		assertDistance(2, fullSensitive, "abcd", "bc");
		
		assertDistance(2, fullSensitive, "abcd", "yzabcd");
		assertDistance(3, fullSensitive, "abcd", "xyzabcd");
		assertDistance(3, fullSensitive, "abcd", "wvxyzabcd");
	}
	
	public void testDistance_insensitive() {
		LevenshteinDistance fullSensitive = new LevenshteinDistance(false, 0);
		
		assertDistance(0, fullSensitive, "abcd", "abcd");
		assertDistance(0, fullSensitive, "abcd", "ABCD");
		assertDistance(0, fullSensitive, "abcd", "aBcD");
		
		assertDistance(1, fullSensitive, "abcd", "axcd");
		assertDistance(1, fullSensitive, "abcd", "acd");
		assertDistance(1, fullSensitive, "abcd", "abxcd");

		assertDistance(4, fullSensitive, "abcd", "");
		assertDistance(4, fullSensitive, "abcd", "xyz");
		assertDistance(4, fullSensitive, "abcd", "abcdabcd");
	}

}
