package de.brightbyte.data.measure;

import java.util.Set;

import de.brightbyte.data.LabeledVector;

public class LabelSetSimilarity<K> implements Similarity<LabeledVector<K>> {
	
	private Similarity<Set<K>> setSimilarity;
	
	public LabelSetSimilarity(Similarity<Set<K>> setSimilarity) {
		super();
		this.setSimilarity = setSimilarity;
	}

	public double similarity(LabeledVector<K> a, LabeledVector<K> b) {
		if (a==b || a.equals(b)) return 1;
		
		return setSimilarity.similarity(a.labels(), b.labels());
	}

}
