package de.brightbyte.data.measure;

import java.util.Set;

import de.brightbyte.data.LabeledVector;
import de.brightbyte.data.MapLabeledVector;

public class FeatureSetSimilarity<K> implements Similarity<Set<K>> {
	
	private Similarity<LabeledVector<K>> vectorSimilarity;
	
	public FeatureSetSimilarity(Similarity<LabeledVector<K>> vectorSimilarity) {
		super();
		this.vectorSimilarity = vectorSimilarity;
	}

	public double similarity(Set<K> a, Set<K> b) {
		if (a==b || a.equals(b)) return 1;
		
		LabeledVector<K> va = new MapLabeledVector<K>(a, 1);
		LabeledVector<K> vb = new MapLabeledVector<K>(b, 1);
		return vectorSimilarity.similarity(va, vb);
	}

}
