package de.brightbyte.data.measure;

import de.brightbyte.data.LabeledVector;

public class EuclideanVectorDistance<K> implements Distance<LabeledVector<K>> {

	public double distance(LabeledVector<K> a, LabeledVector<K> b) {
		if (a==b || a.equals(b)) return 0;
		
		double d = 0;
		for (K feature: a.combinedLabels(b)) {
			double w1 = a.get(feature);
			double w2 = b.get(feature);
			d +=  Math.abs(w1 - w2);
		}
		
		return d;
	}

}
