package de.brightbyte.data.measure;

public class DistanceMeasure<T> implements Measure<T> {

	protected Distance<T> distance; 
	protected T prototype;
	
	public DistanceMeasure(Distance<T> distance, T prototype) {
		super();
		this.distance = distance;
		this.prototype = prototype;
	}

	public double measure(T obj) {
		return distance.distance(prototype, obj);
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((distance == null) ? 0 : distance.hashCode());
		result = PRIME * result + ((prototype == null) ? 0 : prototype.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final DistanceMeasure other = (DistanceMeasure) obj;
		if (distance == null) {
			if (other.distance != null)
				return false;
		} else if (!distance.equals(other.distance))
			return false;
		if (prototype == null) {
			if (other.prototype != null)
				return false;
		} else if (!prototype.equals(other.prototype))
			return false;
		return true;
	}

	
}
