package de.brightbyte.data.measure;


public class DistanceAsSimilarity<T> implements Similarity<T> {
	
	protected Distance<T> distance;
	protected double scale;
	
	public DistanceAsSimilarity(Distance<T> distance) {
		this(distance, 1);
	}

	public DistanceAsSimilarity(Distance<T> distance, double scale) {
		if (distance==null) throw new NullPointerException();
		this.distance = distance;
		this.scale = scale;
	}

	public double similarity(T a, T b) {
		return scale / ( distance.distance(a, b) + 1);
	}

}
