package de.brightbyte.data.measure;

import java.util.Set;

public class DiceSetSimilarity<T> implements Similarity<Set<T>> {

	public double similarity(Set<T> a, Set<T> b) {
		if (a==b || a.equals(b)) return 1;
		
		int overlap = 0;
		
		for (T x: a) {
			if (b.contains(x)) {
				overlap++;
			}
		}
		
		return 2 * (double)overlap / ( a.size() + b.size() );
	}

}
