package de.brightbyte.data.measure;

import de.brightbyte.data.LabeledVector;

public class CosineVectorSimilarity<T> implements Similarity<LabeledVector<T>> {

	public double similarity(LabeledVector<T> a, LabeledVector<T> b) {
		if (a==b || a.equals(b)) return 1;
		
		double sc = a.scalar(b);
		if (sc==0) return sc;
		
		double la = a.getLength();
		double lb = b.getLength();
		
		sc /= (la * lb);
		return sc;
	}

}
