package de.brightbyte.data.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import de.brightbyte.data.measure.Measure;

public class GraphRandom {
	public static <V, E> Graph.VertexEntry<V, E> randomVertex(Graph<V, E> g) {
		if (g.getVertexCount()==0) return null;
		
		List<Graph.VertexEntry<V, E>> v = new ArrayList<Graph.VertexEntry<V, E>>(g.vertices());
		int i = (int)Math.floor( Math.random() * v.size() );
		
		return v.get(i);
	}

	public static <V, E> Graph.VertexEntry<V, E> randomVertex(Graph<V, E> g, Measure<Graph.VertexEntry<? super V, ? super E>> probaility) {
		if (g.getVertexCount()==0) return null;
		
		for (int t = 0; t<10; t++) {
			Graph.VertexEntry<V, E>[] r = randomVertices(g, g.getVertexCount());
			
			for (int i=0; i<r.length; i++) {
				Graph.VertexEntry<V, E> v = r[i];
				double p = probaility.measure(v);
				
				if (Math.random()<=p) return v;
			}
		}
		
		throw new RuntimeException("failed to pick a random vertex after 10 runs. Make sure your probability measure provides values that sum up to one over all vertexes");
	}

	public static <V, E> Graph.VertexEntry<V, E>[] randomVertecies(Graph<V, E> g, int n, Measure<Graph.VertexEntry<V, E>> probaility) {
		if (n>g.getVertexCount()) n = g.getVertexCount(); 

		if (n>=g.getVertexCount()) {
			return randomVertices(g, n);
		}
		
		Graph.VertexEntry<V, E>[] random = new Graph.VertexEntry[n];
		if (n==0) return random;
		
		int k = 0;
		
		for (int t = 0; t<10*n && k<random.length; t++) {
			Graph.VertexEntry<V, E>[] r = randomVertices(g, g.getVertexCount());
			
			for (int i=0; i<r.length && k<random.length; i++) {
				Graph.VertexEntry<V, E> v = r[i];
				double p = probaility.measure(v);
				
				if (Math.random()<=p) random[k++] = v;
			}
		}
		
		if (k<random.length) throw new RuntimeException("failed to pick "+n+" random vertecies after "+10*n+" runs. Make sure your probability measure provides values that sum up to one over all vertexes");
		return random;
	}

	public static <V, E> Graph.VertexEntry<V, E>[] randomVertices(Graph<V, E> g, int n) {
		List<Graph.VertexEntry<V, E>> v = new ArrayList<Graph.VertexEntry<V, E>>(g.vertices());
		Collections.shuffle(v);
		
		if (n<v.size()) v = v.subList(0, n); 
		Graph.VertexEntry<V, E>[] r = v.toArray(new Graph.VertexEntry[v.size()]);
		return r;
	}
	
	public static <V, E> Graph.EdgeEntry<V, E> randomEdge(Graph.VertexEntry<V, E> v, Graph.Relation rel) {
		List<Graph.EdgeEntry<V, E>> e = new ArrayList<Graph.EdgeEntry<V, E>>(v.getEdges(rel));
		if (e.size()==0) return null;
		
		int i = (int)Math.floor( Math.random() * e.size() );
		
		return e.get(i);
	}

	public static <V, E> Graph.EdgeEntry<V, E>[] randomEdges(Graph.VertexEntry<V, E> v, Graph.Relation rel, int n) {
		List<Graph.EdgeEntry<V, E>> e = new ArrayList<Graph.EdgeEntry<V, E>>(v.getEdges(rel));
		Collections.shuffle(e);
		
		if (n<e.size()) e = e.subList(0, n); 
		Graph.EdgeEntry<V, E>[] r = e.toArray(new Graph.EdgeEntry[e.size()]);
		return r;
	}
	
	
}
