package de.brightbyte.data.graph;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;

import de.brightbyte.data.measure.Measure;

public interface Graph<V, E> {
	
	public static enum Relation {
		STRONG, WEAK, IN, OUT
	}
	
	public interface EdgeEntry<V, E> {
		public V getOrigin();
		public V getDestination();
		public E getValue();
	}
	
	public interface VertexEntry<V, E> {
		public Collection<EdgeEntry<V, E>> getEdges(Relation rel);
		public E getEdgeValue(V vertex, Relation rel);
		public V getValue();
		public int getDegree(Relation rel);
	}
	
	public static final Comparator<Graph> byVertexCount = new Comparator<Graph>(){
		public int compare(Graph g1, Graph g2) {
			return g1.getVertexCount() - g2.getVertexCount();
		}
	};
	
	public static final Measure<VertexEntry<?, ?>> inDegree = new Measure<VertexEntry<?, ?>>() {
		public double measure(VertexEntry<?, ?> ve) {
			return ve.getDegree(Relation.IN);
		}
	};
	
	public static final Measure<VertexEntry<?, ?>> outDegree = new Measure<VertexEntry<?, ?>>() {
		public double measure(VertexEntry<?, ?> ve) {
			return ve.getDegree(Relation.OUT);
		}
	};
	
	public Set<V> vertexSet(); 
	public Collection<VertexEntry<V, E>> vertices(); 
	public Collection<EdgeEntry<V, E>>  edges();
	public VertexEntry<V, E> getVertex(V v);
	
	public void putGraph(Graph<V, E> g);
	
	public V putVertex(V v);
	public E putEdge(V v, V w, E e);
	
	public boolean removeVertex(V v);
	public E removeEdge(V v, V w);

	public int removeVertecies(Collection<V> v);
	public int retainVertecies(Collection<V> v);
	
	public E getEdgeValue(V v, V w, Relation rel);
	public Collection<EdgeEntry<V, E>>  getEdges(V v, Relation rel);
	public Graph<V, E> neighbourhood(V center, Relation rel);	
	
	public int getVertexCount();
	public int getEdgeCount();
	
	public void dump(PrintWriter output);
	public void dump(PrintStream output);
}
