package de.brightbyte.data.filter;

public class SubstringFilter implements Filter<String> { 
	protected String match;
	protected boolean sensitive;
	
	public SubstringFilter(String match) {
		this(match, false);
	}
	
	public SubstringFilter(String match, boolean sensitive) {
		if (match == null) throw new NullPointerException("match must not be null");

		if (!sensitive) match = match.toLowerCase();
		
		this.sensitive = sensitive;
		this.match = match;
	}
	
	public boolean matches(String s) {
		if (match==null) return true;
		if (s==null) return false;
		
		if (!sensitive) s = s.toLowerCase();
		
		int idx = s.indexOf(match);
		return idx >= 0;
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((match == null) ? 0 : match.hashCode());
		result = PRIME * result + (sensitive ? 1231 : 1237);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final SubstringFilter other = (SubstringFilter) obj;
		if (match == null) {
			if (other.match != null)
				return false;
		} else if (!match.equals(other.match))
			return false;
		if (sensitive != other.sensitive)
			return false;
		return true;
	}
	
}
