package de.brightbyte.data.filter;

import java.text.Collator;

public class StringFilter implements Filter<String> { 
	protected String match;
	protected Collator collator;
	
	public StringFilter(String match) {
		this(match, false);
	}
	
	public StringFilter(String match, boolean sensitive) {
		this(match, sensitive ? Collator.TERTIARY : Collator.SECONDARY);
	}
	
	public StringFilter(String match, int strength) {
		this(match, Collator.getInstance());
		
		collator.setStrength(strength);
	}
	
	public StringFilter(String match, Collator collator) {
		if (match == null) throw new NullPointerException("match must not be null");
		if (collator == null) throw new NullPointerException("collator must not be null");
		
		this.collator = collator;
		this.match = match;
	}
	
	public boolean matches(String s) {
		return collator.equals(match, s);
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((collator == null) ? 0 : collator.hashCode());
		result = PRIME * result + ((match == null) ? 0 : match.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final StringFilter other = (StringFilter) obj;
		if (collator == null) {
			if (other.collator != null)
				return false;
		} else if (!collator.equals(other.collator))
			return false;
		if (match == null) {
			if (other.match != null)
				return false;
		} else if (!match.equals(other.match))
			return false;
		return true;
	}
	
}
