package de.brightbyte.data.filter;

public class InverseFilter<T> implements Filter<T> {
	protected Filter<T> filter;
	
	public InverseFilter(Filter<T> filter) {
		if (filter==null) throw new NullPointerException();
		this.filter = filter;
	}

	public boolean matches(T obj) {
		return !filter.matches(obj);
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((filter == null) ? 0 : filter.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final InverseFilter other = (InverseFilter) obj;
		if (filter == null) {
			if (other.filter != null)
				return false;
		} else if (!filter.equals(other.filter))
			return false;
		return true;
	}

}
