package de.brightbyte.data.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class FixedSetFilter<T> implements Filter<T> {
	private Set<T> values;
	
	public FixedSetFilter(T[] values) {
		this( Arrays.asList(values) );
	}
	
	public FixedSetFilter(Collection<T> values) {
		this.values = new HashSet<T>(values);
	}
	
	public boolean matches(T obj) {
		return values.contains(obj);
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((values == null) ? 0 : values.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final FixedSetFilter other = (FixedSetFilter) obj;
		if (values == null) {
			if (other.values != null)
				return false;
		} else if (!values.equals(other.values))
			return false;
		return true;
	}

}
