package de.brightbyte.data.filter;

import java.util.Collection;
import java.util.Iterator;

public class Filters {
	
	public static final Filter<Object> all = new Filter<Object>(){

		public boolean matches(Object obj){
			return true;
		}
	
		@Override
		public boolean equals(Object f) {
			return f == this;
		}
		
		@Override
		public int hashCode() {
			return getClass().hashCode();
		}
	};
	
	public static final Filter<Object> none = new InverseFilter<Object>(all);
	
	public static <T> void remove(Collection<T> list, Filter<T> filter) {
		Iterator<T> it = list.iterator();
		while (it.hasNext()) {
			if (filter.matches(it.next())) it.remove();
		}
	}

	public static <T> void retain(Collection<T> list, Filter<T> filter) {
		Iterator<T> it = list.iterator();
		while (it.hasNext()) {
			if (!filter.matches(it.next())) it.remove();
		}
	}
}
