package de.brightbyte.data.filter;

/**
 * Filter that matches if the filtered object is equal to a given sample object.
 * 
 * @author daniel
 */
public class EqualityFilter implements Filter<Object> { 
	protected Object match;
	protected boolean lenient;
	
	public EqualityFilter(Object match) {
		this(match, true);
	}
	
	public EqualityFilter(Object match, boolean lenient) {
		this.match = match;
		this.lenient = lenient;
	}
	
	public boolean matches(Object o) {
		if (match==o) return true;
		if (match==null && o!=null || o==null) return false;
		
		if (lenient) {
			if (match instanceof String) {
				if (! (o instanceof String)) o = o.toString();
			}
			else {
				if (o instanceof String) match = match.toString();
			}
		}
		
		return match.equals(o);
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + (lenient ? 1231 : 1237);
		result = PRIME * result + ((match == null) ? 0 : match.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final EqualityFilter other = (EqualityFilter) obj;
		if (lenient != other.lenient)
			return false;
		if (match == null) {
			if (other.match != null)
				return false;
		} else if (!match.equals(other.match))
			return false;
		return true;
	}
	
	
}
