/**
 * 
 */
package de.brightbyte.data.cursor;

import java.util.Iterator;

import de.brightbyte.util.PersistenceException;
import de.brightbyte.util.UncheckedPersistenceException;

public class CursorIterator<T> implements Iterator<T>{
	protected DataCursor<T> cursor;
	protected T current;
	
	public CursorIterator(DataCursor<T> cursor) throws PersistenceException {
		try {
			this.cursor = cursor;
			step();
		} catch (PersistenceException e) {
			throw new UncheckedPersistenceException(e); //XXX: fugly hack :(
		}
	}

	public boolean hasNext() {
		return current!=null;
	}
	
	protected void step() throws PersistenceException {
		current = cursor.next();
		if (current==null) cursor.close();
	}

	public T next() {
		try {
			if (current==null) return null;
			T n = current;
			step();
			return n;
		} catch (PersistenceException e) {
			throw new UncheckedPersistenceException(e); //XXX: fugly hack :(
		}
	}

	public void remove() {
		throw new UnsupportedOperationException();
	}
	
	protected void finalize() {
		cursor.close();
	}
}