package de.brightbyte.data.cursor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import de.brightbyte.util.PersistenceException;

public class CollectionDataSet<T> implements DataSet<T> {

	protected Iterable<T> iterable;
	
	public CollectionDataSet(T[] data) {
		this(Arrays.asList(data));
	}

	public CollectionDataSet(Iterable<T> iterable) {
		this.iterable = iterable;
	}

	public DataCursor<T> cursor() throws PersistenceException {
		return new IteratorCursor<T>(iterator());
	}

	public Iterator<T> iterator() {
		return iterable.iterator();
	}
	
	public List<T> load() {
		if (iterable instanceof List) {
			return Collections.unmodifiableList((List<T>)iterable);
		}
		
		ArrayList<T> r = new ArrayList<T>();
		for (T x: iterable) r.add(x);
		return r;
	}
}
