package de.brightbyte.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SimpleBloomSet<T> extends AbstractBloomSet<T>{
	private byte[] bits;
	public SimpleBloomSet(String algorithm) throws NoSuchAlgorithmException {
		this(MessageDigest.getInstance(algorithm));
	}
	
	public SimpleBloomSet(MessageDigest digest) {
		super(digest);
		int width = digest.getDigestLength();
		if (width==0) throw new IllegalArgumentException("digest does not report width: "+digest);
		
		this.bits = new byte[width];
	}
	
	public void add(T value) {
		byte[] h = hash(value);
		
		for (int i=0; i<bits.length; i++) {
			bits[i] |= h[i];
		}
	}
	
	public boolean contains(T value) {
		byte[] h = hash(value);
		
		for (int i=0; i<bits.length; i++) {
			if ( (bits[i] & h[i]) != h[i] ) return false;
		}
		
		return true;
	}
	
	public static void main(String[] args) throws NoSuchAlgorithmException, IOException {
		BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
		
		BloomSet<String> set = new SimpleBloomSet<String>("MD5");
		System.out.printf("BloomSet bits: %d\n", set.getBits());
		
		while (true) {
			String s = in.readLine();
			if (s==null) break;
			
			s= s.trim();
			if (s.length()==0) break;
			
			set.add(s);
		}

		while (true) {
			String s = in.readLine();
			if (s==null) break;

			s= s.trim();
			if (s.length()==0) break;
			
			if (set.contains(s)) System.out.printf("yes\n");
			else System.out.printf("no\n");
		}
	}
}
