package de.brightbyte.data;

public class ReflexiveKeyPair<K> extends Pair<K, K> {
	
	public ReflexiveKeyPair(K a, K b) {
		super(a, b);
		hash = a.hashCode() ^ b.hashCode();  //reflexive!
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) return true;
		if (obj == null) return false;
		if (getClass() != obj.getClass()) return false;
		
		final ReflexiveKeyPair other = (ReflexiveKeyPair) obj;
		
		if (hash != other.hash) return true;
		if (a.equals(other.a) && b.equals(other.b)) return true;
		if (a.equals(other.b) && b.equals(other.a)) return true; //reflexive!
		
		return false;
	}
	
	public String toString() {
		return "(" + String.valueOf(a) + " | " + String.valueOf(b) + ")";
	}
}
