package de.brightbyte.data;

public class Pair <A, B> {
	protected A a;
	protected B b;
	protected int hash;
	
	public Pair(A a, B b) {
		this.a = a;
		this.b = b;

		final int PRIME = 31;
		hash = 1;
		hash = PRIME * hash + ((a == null) ? 0 : a.hashCode());
		hash = PRIME * hash + ((b == null) ? 0 : b.hashCode());
	}

	public A getA() {
		return a;
	}

	public B getB() {
		return b;
	}

	@Override
	public int hashCode() {
		return hash;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		
		final Pair other = (Pair) obj;
		
		if (hash != other.hash)
			return false;
		
		if (a == null) {
			if (other.a != null)
				return false;
		} else if (!a.equals(other.a))
			return false;
		
		if (b == null) {
			if (other.b != null)
				return false;
		} else if (!b.equals(other.b))
			return false;
		
		return true;
	}
		
	public String toString() {
		return "(" + String.valueOf(a) + ", " + String.valueOf(b) + ")";
	}
	
}
