package de.brightbyte.data;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Set;

public interface LabeledVector<K> {
	
	public LabeledVector<K> difference(LabeledVector<K> v);
	public double distance(LabeledVector<K> v);
	public LabeledVector<K> summ(LabeledVector<K> v);
	public double scalar(LabeledVector<K> v);
	public LabeledVector<K> scaled(double scale);
	public double getLength();
	public double getTotal();
	
	public Set<K> labels();
	public Iterable<K> combinedLabels(LabeledVector<K> other);
	
	public void remove(K key);
	public void add(LabeledVector<K> weights);
	public void add(K key, double value);
	public void set(LabeledVector<K> weights);
	public void set(K key, double value);
	public double get(K label);

	public void trim(double min, double max);

	public int size();
	public double total();
	
	public void dump(PrintWriter output);
	public void dump(PrintStream output);
	
}
