package de.brightbyte.data;

import java.io.PrintStream;
import java.io.PrintWriter;


public interface LabeledMatrix<K, L> {
	public LabeledVector<L> row(K r);
	public LabeledVector<K> column(L c);
	public Iterable<K> rows();
	public Iterable<L> columns();
	public int getRowCount();
	public int getColumnCount();
	public double get(K r, L c);
	public void set(K r, L c, double d);
	public void add(K r, L c, double d);
	public void merge(K r, L c, double d); //merge probability (~OR)
	public void dump(PrintWriter output);
	public void dump(PrintStream output);
	public void removeRow(K r);
	public void removeColumn(L c);
	public void trim(double min, double max);
	public boolean isSymmetric();
	public boolean contains(K r, L b);
}
