package de.brightbyte.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Functors {
	public static <S, T>List<T> apply(List<S> data, Functor<T, S> f) {
		ArrayList<T> a = new ArrayList<T>(data.size());
		for (S s : data) {
			T t = f.apply(s);
			a.add(t);
		}
		return a;
	}
	
	public static <K, S, T>Map<K, T> apply(Map<K, S> data, Functor<T, S> f) {
		HashMap<K, T> a = new HashMap<K, T>(data.size());
		for (Map.Entry<K, S> e : data.entrySet()) {
			T t = f.apply(e.getValue());
			a.put(e.getKey(), t);
		}
		return a;
	}

	public static <T> T fold(List<T> data, Functor2<T, T, T> f) {
		T akk = null;
		for (T t : data) {
			akk = f.apply(akk, t);
		}
		
		return akk;
	}
	
}
