package de.brightbyte.data;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class AbstractBloomSet<T> implements BloomSet<T> {

	private MessageDigest digest;
	
	public AbstractBloomSet(String algorithm) throws NoSuchAlgorithmException {
		this(MessageDigest.getInstance(algorithm));
	}
	
	public AbstractBloomSet(MessageDigest digest) {
		if (digest==null) throw new NullPointerException();
		this.digest = digest;
	}

	protected byte[] hash(T value) {
		byte[] bytes = asBytes(value);
		digest.update(bytes);
		return digest.digest();
	}

	protected byte[] asBytes(T value) {
		byte[] bytes;
		
		if (value instanceof String) {
			bytes = ((String)value).getBytes(); //FIXME: encoding!
		}
		else if (!(value instanceof byte[])) {
			throw new IllegalArgumentException("value must be a string or a byte array!");
		}
		else {
			bytes = (byte[])value;
		}
		
		return bytes;
	}

	public int getBits() {
		return digest.getDigestLength() * 8;
	}

}
