package de.brightbyte.axis;

import java.util.Map;

public class CastAxisProvider<T, O> implements AxisProvider<T, O> {

	private String axis;
	private Class<T> axisType;
	private Class<O> objectType;
	
	public CastAxisProvider(String axis, Class<T> axisType, Class<O> objectType) {
		if (axis==null) throw new NullPointerException();
		if (axisType==null) throw new NullPointerException();
		if (objectType==null) throw new NullPointerException();
		
		this.axis = axis;
		this.axisType = axisType;
		this.objectType = objectType;
	}
	
	@SuppressWarnings("unchecked")
	public T getAxis(O obj, Map<String, Object> options) {
		if (!objectType.isInstance(obj)) throw new IllegalArgumentException(obj.getClass()+" is incompatible to "+objectType);
		return (T)obj;
	}

	public String getAxisName() {
		return axis;
	}

	public Class<T> getAxisType() {
		return axisType;
	}

}
