package de.brightbyte.axis;

import de.brightbyte.util.SpiTools;

public class Axis {

	protected static AxisManager spi = SpiTools.newDefaultSPI(Axis.class, AxisManager.class, "de.brightbyte.axis.DefaultAxisManager");
	
	public static <T> T get(String axis, Object obj) throws UnsupportedAxisException {
		return spi.<T, Object>getAxis(axis, obj);
	}
	
	public static boolean has(String axis, Object obj) {
		return spi.hasAxis(axis, obj);
	}
	
	public static Class<?> type(String axis, Object obj) throws UnsupportedAxisException {
		return spi.getAxisType(axis);
	}

	public static void declare(String axis, Class iface) {
		spi.declareAxis(axis, iface);
	}

	public static <T, O> void register(AxisProvider<T, O> provider) throws UnsupportedAxisException {
		spi.registerProvider(provider);
	}
}
