package de.brightbyte.axis;

import java.util.Map;

public class AwareAxisProvider<T> implements AxisProvider<T, AxisAware> {

	private String axis;
	private Class<T> axisType;
	
	public AwareAxisProvider(String axis, Class<T> axisType) {
		if (axis==null) throw new NullPointerException();
		if (axisType==null) throw new NullPointerException();
		
		this.axis = axis;
		this.axisType = axisType;
	}
	
	@SuppressWarnings("unchecked")
	public T getAxis(AxisAware aa, Map options) {
		return (T)aa.getAxis(axis, options);
	}

	public String getAxisName() {
		return axis;
	}

	public Class<T> getAxisType() {
		return axisType;
	}

}
