package de.brightbyte.audit;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

import de.brightbyte.util.BeanUtils;
import de.brightbyte.util.StringUtils;

public class ProfilingWrapper implements InvocationHandler {
	
	protected Object target;
	protected String prefix;

	public ProfilingWrapper(Object target, String name) {
		this.target = target;
		this.prefix = name + ": " + target.getClass().getName();
	}

	public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
		Object result;
		Throwable error = null;
		
		String astring = args == null ? "" : "(" + StringUtils.join(",", args) + ")";
		
		String n =  prefix + "." + method.getName() + "(" + astring + ")";
		
		long t = DebugUtil.profileIn(n);
		
		try {
			result = method.invoke(target, args);
			return result;
		}
		catch (InvocationTargetException ex) {
			error = ex;
			throw ex;
		}
		finally {
			if (error!=null) n+= " (ERROR: "+error+")";
			DebugUtil.profileOut(n, t);
		}
	}
	
	public static Object wrap(Object target, String name) {
		Class[] interfaces = BeanUtils.collectInterfaces(target.getClass());
		return Proxy.newProxyInstance(ProfilingWrapper.class.getClassLoader(), interfaces, new ProfilingWrapper(target, name));
	}

}
