package de.brightbyte.audit;

import java.awt.Component;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;

import javax.swing.SwingUtilities;

import de.brightbyte.io.ConsoleIO;
import de.brightbyte.util.Logger;



public class DebugUtil {
	
	private static final Logger logger = Logger.getLogger(DebugUtil.class);

	protected static int debugDelay = 0;
	protected static boolean profiling = false;
	protected static long startTime = System.currentTimeMillis();
	
	public static int getDebugDelay() {
		return debugDelay;
	}

	public static void setDebugDelay(int debugDelay) {
		DebugUtil.debugDelay = debugDelay;
	}

	public static boolean isProfiling() {
		return profiling;
	}

	public static void setProfiling(boolean profiling) {
		DebugUtil.profiling = profiling;
	}

	public static void debugDelay(int ticks) {
		assertNotAwt("debugDelay()");
		
		if (ticks==0) return;
		if (debugDelay <= 0) return;
		
		try {
			Thread.sleep(debugDelay * ticks);
		} catch (InterruptedException e) {
			Thread.currentThread().interrupt();
		}
	}
	
	public static void assertInAwt(String what) {
		if (!SwingUtilities.isEventDispatchThread())
			throw new RuntimeException("Must only be called in AWT thread: "+what);
	}

	public static void assertNotAwt(String what) {
		if (SwingUtilities.isEventDispatchThread())
			throw new RuntimeException("Must not be called in AWT thread: "+what);
	}
	
	public static long profileIn(String name) {
		if (!profiling) return 0;
		
		long t = System.currentTimeMillis();
		
		return t;
	}
	
	public static void profileOut(String name, long inTime) {
		if (!profiling || inTime <= 0) return;
		
		long t = System.currentTimeMillis() - inTime;
		
		logger.debug("PROFILING: "+name+": "+t+" ms");
	}

	public static void profileTimeSinceStart(String name) {
		profileOut("TOTAL TIME TO: "+name, startTime);
	}

	public static String debugName(Object obj) {
		if (obj==null) return "<null>";
		if (obj instanceof Component) {
			return obj.getClass().getName()+"#"+System.identityHashCode(obj);
		}
		return obj.toString();
	}
	
	public static void dumpClassPath(ClassLoader cl, PrintStream out) {
		while (cl!=null) {
			out.println(cl.getClass().getName());
			
			if (cl instanceof URLClassLoader) {
				URLClassLoader ucl = (URLClassLoader)cl;
				URL[] urls = ucl.getURLs();
				
				for (int i = 0; i < urls.length; i++) {
					ConsoleIO.output.println("\t" + urls[i]);
				}
			}
			
			cl = cl.getParent();
		}
	}
}
