package de.brightbyte.abstraction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ValidationResult {
	protected List<String> problems;
	
	public void addProblem(String problem) {
		if (problems==null) problems = new ArrayList<String>(); 
		problems.add(problem);
	}
	
	public boolean hasProblems() {
		return problems!=null && !problems.isEmpty();
	}
	
	public Iterable<String> getProblems() {
		return Collections.unmodifiableList(problems);
	}

	public String toString() {
		if (problems==null || problems.size()==0) return "no problems";
		
		StringBuilder s = new StringBuilder();
		for (String p: problems) {
			if (s.length()>0) s.append("\n");
			s.append(p);
		}
		
		return s.toString();
	}
}
