package de.brightbyte.abstraction;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleAbstractor implements Abstractor<ResourceBundle> {

	public static final ResourceBundleAbstractor instance = new ResourceBundleAbstractor();
	
	public Object getProperty(ResourceBundle obj, String name) throws IllegalArgumentException {
		try {
			return obj.getObject(name);
		}
		catch (MissingResourceException ex) {
			return null;
		}
	}

	public Class getPropertyType(String property) {
		return Object.class;
	}

	public Class<ResourceBundle> getTargetType() {
		return ResourceBundle.class;
	}

	public boolean isPropertyMutable(String name) {
		return false;
	}

	public void setProperty(ResourceBundle obj, String name, Object v) throws IllegalArgumentException {
		throw new UnsupportedOperationException();
	}

	public boolean hasProperty(ResourceBundle obj, String name) {
		try {
			obj.getObject(name);
			return true;
		} catch (MissingResourceException e) {
			return false;
		}
	}
	
}
