package de.brightbyte.abstraction;

import java.util.Comparator;

public interface PropertyInfo<T, V> extends PropertyAccessor<T, V> {
	public String getName();
	public String getLabel(); //XXX: locale? GUI only?
	public Class<V> getType();

	public Comparator<V> getComparator();

	public V getValue(T record);  //-> accessor
	public void setValue(T record, V value); //-> accessor
	public boolean isMutable(); //-> accessor
	
	public String format(V value); //-> pattern, formatter
	public V parse(String s);      //-> pattern, parser
	public boolean isWellformed(String s); //-> pattern, parser
	
	public boolean validate(V value, ValidationResult result); //-> validator
	public boolean isValid(V value); //-> validator
	
	public Object getFeature(String feature);
}
