package de.brightbyte.abstraction;

import de.brightbyte.data.filter.Filter;

/**
 * A Filter implementation that uses PropertyExtractor to get a property value
 * from a given record, and the applies another filter to it. That is, it provides
 * a way to filter records using a specific property.
 * 
 * @author daniel
 *
 * @param <T>
 */
public class PropertyFilter<T, V> implements Filter<T> { 
	protected PropertyInfo<T, V> property;
	protected Filter<V> filter;

	public PropertyFilter(PropertyInfo<T, V> property, Filter<V> filter) {
		if (property == null) throw new NullPointerException("property must not be null");
		if (filter == null) throw new NullPointerException("filter must not be null");
		
		this.property = property;
		this.filter = filter;
	}

	public boolean matches(T rec)  {
		V v = property.getValue(rec);
		return filter.matches(v);
	}

	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((filter == null) ? 0 : filter.hashCode());
		result = PRIME * result + ((property == null) ? 0 : property.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final PropertyFilter other = (PropertyFilter) obj;
		if (filter == null) {
			if (other.filter != null)
				return false;
		} else if (!filter.equals(other.filter))
			return false;
		if (property == null) {
			if (other.property != null)
				return false;
		} else if (!property.equals(other.property))
			return false;
		return true;
	}
	
}
