package de.brightbyte.abstraction;

/**
 * Provides access to the properties of a specific object
 */
public interface PropertyAccessible {
	public static final Abstractor<PropertyAccessible> abstractor = new Abstractor<PropertyAccessible>() {
	
		public void setProperty(PropertyAccessible obj, String name, Object v)
				throws IllegalArgumentException {
			
			obj.setProperty(name, v);
		}
	
		public boolean isPropertyMutable(String name) {
			return false;
		}
	
		public Class<PropertyAccessible> getTargetType() {
			return PropertyAccessible.class;
		}
	
		public Class getPropertyType(String property) {
			return Object.class;
		}
	
		public Object getProperty(PropertyAccessible obj, String name)
				throws IllegalArgumentException {
			
			return obj.getProperty(name);
		}

		public boolean hasProperty(PropertyAccessible obj, String name) {
			return obj.hasProperty(name);
		}
	
	};

	public static class Accessor<V> extends AbstractAccessor<PropertyAccessible, V> {
		
		public Accessor(String property, Class<V> type) {
			super(property, type);
		}

		public V getValue(PropertyAccessible obj) {
			return checkType((V)obj.getProperty(property));
		}

		public boolean isMutable() {
			return true; //FIXME!
		}

		public void setValue(PropertyAccessible obj, V value) {
			obj.setProperty(property, checkType(value));
		}

	}
	
	public Object getProperty(String name) throws IllegalArgumentException;
	public boolean hasProperty(String name);
	public void setProperty(String name, Object v) throws IllegalArgumentException;
	public boolean isPropertyMutable(String name);
}
