package de.brightbyte.abstraction;

import java.util.Map;

public class MapAbstractor implements Abstractor<Map<String, ?>> {

	public static final MapAbstractor instance = new MapAbstractor();
	
	public Object getProperty(Map<String, ?> obj, String name) throws IllegalArgumentException {
		return obj.get(name);
	}

	public Class getPropertyType(String property) {
		return Object.class;
	}

	public Class<Map<String, ?>> getTargetType() {
		return (Class<Map<String, ?>>)(Object)Map.class;
	}

	public boolean isPropertyMutable(String name) {
		return true;
	}

	public void setProperty(Map<String, ?> obj, String name, Object v) throws IllegalArgumentException {
		((Map<String, Object>)obj).put(name, v);
	}
	
	public boolean hasProperty(Map obj, String name) {
		return obj.containsKey(name);
	}
	
}
