package de.brightbyte.abstraction;

import javax.swing.table.TableColumn;

public interface GuiPropertyInfo<T, V> extends PropertyInfo<T, V> {
	public int getDisplayWidth();  //pixels
	public int getDisplayLength(); //characters
	public int getAlignment();     //SwingConstants: left/center/right, leading/trailing
	public ValueRenderer<V> newRenderer();
	public ValueEditor<V> newEditor();
	public boolean isEditable(T record); //note quite the same as isMutable
	public Object getDefaultValue(); //xxx: pull up?
	public boolean isHidden();
	public TableColumn makeTableColumn(int modelIndex);
}
