package de.brightbyte.abstraction;

public class GenericAccessor<T, V> extends AbstractAccessor<T, V> {
	
	protected Abstractor<T> abstractor;
	
	public GenericAccessor(String property, Class<V> type) {
		super(property, type);
	}

	public V getValue(T obj) {
		return checkType(abstractor.getProperty(obj, property));
	}

	public boolean isMutable() {
		return abstractor.isPropertyMutable(property);
	}

	public void setValue(T obj, V value) {
		abstractor.setProperty(obj, property, checkType(value));
	}

}
