package de.brightbyte.abstraction;

import java.beans.PropertyChangeListener;

/**
 * Provides abstract access to properties, methods and event sets for a class of objects
 */
public interface ExtendedAbstractor<T> extends Abstractor<T> {
	public Class<T> getTargetType();
	
	public Object getProperty(T obj, String name) throws IllegalArgumentException;
	public void setProperty(T obj, String name, Object v) throws IllegalArgumentException;
	
	public Object call(T obj, String name, Object[] args) throws Exception;
	
	public void addListener(T obj, String event, PropertyChangeListener li) throws IllegalArgumentException;
	public void removeListener(T obj, String event, PropertyChangeListener li) throws IllegalArgumentException;
	
	public void addPropertyChangeListener(T obj, String property, PropertyChangeListener li) throws IllegalArgumentException;
	public void removePropertyChangeListener(T obj, String property, PropertyChangeListener li) throws IllegalArgumentException;

	public boolean isPropertyMutable(String name);
	public Class getPropertyType(String property);
}
