package de.brightbyte.abstraction;

import java.beans.IntrospectionException;
import java.beans.PropertyChangeListener;

/**
 * An Abstraction is a binding of an Abstractor to a specific object; 
 * It provides abstract access to the properties, methods and event sets of that object.
 */
public class ExtendedAbstraction<T> extends Abstraction<T> {
	protected ExtendedAbstractor<T> abstractor;
	
	@SuppressWarnings("unchecked")
	public ExtendedAbstraction(T object) throws IntrospectionException {
		this(object, BeanTypeAbstractor.<T>getAbstractor((Class<T>)object.getClass()));
	}
	
	public ExtendedAbstraction(T object, ExtendedAbstractor<T> abstractor) {
		super(object, abstractor);
		if (object==null) throw new NullPointerException();
		if (abstractor==null) throw new NullPointerException();
		
		if (!abstractor.getTargetType().isInstance(object)) {
			throw new IllegalArgumentException("object type "+object.getClass().getName()+" is not compatible with "+abstractor.getTargetType());
		}
		
		this.object = object;
		this.abstractor = abstractor;
	}
	
	public void addListener(String event, PropertyChangeListener li) throws IllegalArgumentException {
		abstractor.addListener(object, event, li);
	}
	
	public void addPropertyChangeListener(String property, PropertyChangeListener li) throws IllegalArgumentException {
		abstractor.addPropertyChangeListener(object, property, li);
	}
	
	public Object call(String name, Object[] args) throws Exception {
		return abstractor.call(object, name, args);
	}
	
	public Object getProperty(String name) throws IllegalArgumentException {
		return abstractor.getProperty(object, name);
	}
	
	public Class getPropertyType(String name) throws IllegalArgumentException {
		return abstractor.getPropertyType(name);
	}
	
	public Class<T> getTargetType() {
		return abstractor.getTargetType();
	}
	
	public void removeListener(String event, PropertyChangeListener li) throws IllegalArgumentException {
		abstractor.removeListener(object, event, li);
	}
	
	public void removePropertyChangeListener(String property, PropertyChangeListener li) throws IllegalArgumentException {
		abstractor.removePropertyChangeListener(object, property, li);
	}
	
	public void setProperty(String name, Object v) throws IllegalArgumentException {
		abstractor.setProperty(object, name, v);
	}

	public boolean isPropertyMutable(String name) {
		return abstractor.isPropertyMutable(name);
	}
	
}
