package de.brightbyte.abstraction;

/**
 * Provides abstract access to properties, methods and event sets for a class of objects
 */
public interface Abstractor<T> {
	public Class<T> getTargetType();
	
	public Object getProperty(T obj, String name) throws IllegalArgumentException;
	public void setProperty(T obj, String name, Object v) throws IllegalArgumentException;

	public boolean isPropertyMutable(String name);
	public Class getPropertyType(String property);

	public boolean hasProperty(T obj, String name);
}
