package de.brightbyte.abstraction;

import java.beans.IntrospectionException;

/**
 * An Abstraction is a binding of an Abstractor to a specific object; 
 * It provides abstract access to the properties, methods and event sets of that object.
 */
public class Abstraction<T> implements PropertyAccessible {
	protected T object;
	protected Abstractor<T> abstractor;
	
	@SuppressWarnings("unchecked")
	public Abstraction(T object) throws IntrospectionException {
		this(object, BeanTypeAbstractor.<T>getAbstractor((Class<T>)object.getClass()));
	}
	
	public Abstraction(T object, Abstractor<T> abstractor) {
		if (object==null) throw new NullPointerException();
		if (abstractor==null) throw new NullPointerException();
		
		if (!abstractor.getTargetType().isInstance(object)) {
			throw new IllegalArgumentException("object type "+object.getClass().getName()+" is not compatible with "+abstractor.getTargetType());
		}
		
		this.object = object;
		this.abstractor = abstractor;
	}
	
	public Object getProperty(String name) throws IllegalArgumentException {
		return abstractor.getProperty(object, name);
	}
	
	public Class getPropertyType(String name) throws IllegalArgumentException {
		return abstractor.getPropertyType(name);
	}
	
	public Class<T> getTargetType() {
		return abstractor.getTargetType();
	}
	
	public void setProperty(String name, Object v) throws IllegalArgumentException {
		abstractor.setProperty(object, name, v);
	}

	public boolean isPropertyMutable(String name) {
		return abstractor.isPropertyMutable(name);
	}

	public boolean hasProperty(String name) {
		return abstractor.hasProperty(object, name);
	}
	
}
