package de.brightbyte.abstraction;

import java.beans.IntrospectionException;

public class AbstractedAccessor<T, V> extends AbstractAccessor<T, V> {
	
	protected Abstractor<T> abstractor;
	
	public AbstractedAccessor(Class<T> recType, String property) throws IntrospectionException {
		this(property, BeanTypeAbstractor.getAbstractor(recType));
	}
	
	public AbstractedAccessor(String property, Abstractor<T> abstractor) {
		super(property, abstractor.getPropertyType(property));
		
		this.abstractor = abstractor;
	}

	public V getValue(T obj) {
		return checkType((V)abstractor.getProperty(obj, property));
	}

	public boolean isMutable() {
		return abstractor.isPropertyMutable(property);
	}

	public void setValue(T obj, V value) {
		abstractor.setProperty(obj, property, checkType(value));
	}

}
