package de.brightbyte.abstraction;

/**
 * Provides access to a specific property for a class of objects
 */
public abstract class AbstractAccessor<T, V> implements PropertyAccessor<T, V> {
	protected String property;
	private Class<V> type;

	public AbstractAccessor(String property, Class<V> type) {
		if (property==null) throw new NullPointerException();
		if (type==null) throw new NullPointerException();
		
		this.property = property;
		this.type = type;
	}

	public String getName() {
		return property;
	}
		
	public Class<V> getType() {
		return type;
	}

	@SuppressWarnings("unchecked")
	protected V checkType(Object v) {
		if (v!=null && type!=null && !type.isInstance(v)) throw new ClassCastException("object of type "+v.getClass().getName()+" is incompatible with "+type);
		return (V)v;
	}
	
	@Override
	public int hashCode() {
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((property == null) ? 0 : property.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final AbstractAccessor other = (AbstractAccessor) obj;
		if (property == null) {
			if (other.property != null)
				return false;
		} else if (!property.equals(other.property))
			return false;
		return true;
	}

}
