package de.brightbyte.rdf.vocab;

import de.brightbyte.rdf.RdfException;
import de.brightbyte.rdf.RdfPlatform;
import de.brightbyte.rdf.RdfNamespace;

/**
 * XML Schema Datatypes, as defined by http://www.w3.org/TR/xmlschema11-2/ 
 * and http://www.w3.org/TR/2004/REC-rdf-schema-20040210/
 */
public class XSDatatypes<V, R extends V> implements RdfNamespace<V, R> {
	public static final String namespace = "http://www.w3.org/2001/XMLSchema-datatypes#";
	
	public final String prefix;
	
	public final R string;
	public final R decimal;
	
	public final R _boolean;
	public final R _float;
	public final R _double;
	public final R _int;
	public final R _byte;
	public final R _long;
	public final R _short;

	public final R unsignedInt;
	public final R unsignedByte;
	public final R unsignedLong;
	public final R unsignedShort;
	
	public final R integer;
	public final R nonNegativeInteger;
	public final R positiveInteger;
	public final R nonPositiveInteger;
	public final R negativeInteger;
	
	public final R dateTime;
	public final R duration;
	public final R date;
	public final R gYearMonth;
	public final R gYear;
	public final R gMonthDay;
	public final R gDay;
	public final R gMonth;
	
	public final R hexBinary;
	public final R base64Binary;
	
	public final R anyURI;
	public final R ID;
	public final R IDREF;
	public final R IDREFS;
	
	public final R ENTITY;
	public final R ENTITYS;
	public final R NOTATION;
	public final R NMTOKEN;
	public final R NMTOKENS;
	
	public final R normalizedString;
	public final R token;
	public final R language;
	
	public final R Name;
	public final R QName;
	public final R NCName;
	
	public XSDatatypes(RdfPlatform<V, R, ?, ?> platform) throws RdfException {
		this(platform, "xsd");
	}
	
	public XSDatatypes(RdfPlatform<V, R, ?, ?> platform, String prefix) throws RdfException {
		this.prefix = prefix;
	
		string = platform.newResource(namespace, "string");
		decimal = platform.newResource(namespace, "decimal");
		
		_boolean = platform.newResource(namespace, "boolean");
		_float = platform.newResource(namespace, "float");
		_double = platform.newResource(namespace, "double");
		_int = platform.newResource(namespace, "int");
		_byte = platform.newResource(namespace, "byte");
		_long = platform.newResource(namespace, "long");
		_short = platform.newResource(namespace, "short");

		unsignedInt = platform.newResource(namespace, "unsignedInt");
		unsignedByte = platform.newResource(namespace, "unsignedByte");
		unsignedLong = platform.newResource(namespace, "unsignedLong");
		unsignedShort = platform.newResource(namespace, "unsignedShort");
		
		integer = platform.newResource(namespace, "integer");
		nonNegativeInteger = platform.newResource(namespace, "nonNegativeInteger");
		positiveInteger = platform.newResource(namespace, "positiveInteger");
		nonPositiveInteger = platform.newResource(namespace, "nonPositiveInteger");
		negativeInteger = platform.newResource(namespace, "negativeInteger");
		
		dateTime = platform.newResource(namespace, "dateTime");
		duration = platform.newResource(namespace, "duration");
		date = platform.newResource(namespace, "date");
		gYearMonth = platform.newResource(namespace, "gYearMonth");
		gYear = platform.newResource(namespace, "gYear");
		gMonthDay = platform.newResource(namespace, "gMonthDay");
		gDay = platform.newResource(namespace, "gDay");
		gMonth = platform.newResource(namespace, "gMonth");
		
		hexBinary = platform.newResource(namespace, "hexBinary");
		base64Binary = platform.newResource(namespace, "base64Binary");
		
		anyURI = platform.newResource(namespace, "anyURI");
		ID = platform.newResource(namespace, "ID");
		IDREF = platform.newResource(namespace, "IDREF");
		IDREFS = platform.newResource(namespace, "IDREFS");
		
		ENTITY = platform.newResource(namespace, "ENTITY");
		ENTITYS = platform.newResource(namespace, "ENTITYS");
		NOTATION = platform.newResource(namespace, "NOTATION");
		NMTOKEN = platform.newResource(namespace, "NMTOKEN");
		NMTOKENS = platform.newResource(namespace, "NMTOKENS");
		
		normalizedString = platform.newResource(namespace, "normalizedString");
		token = platform.newResource(namespace, "token");
		language = platform.newResource(namespace, "language");
		
		Name = platform.newResource(namespace, "Name");
		QName = platform.newResource(namespace, "QName");
		NCName = platform.newResource(namespace, "NCName");
	}

	public String getNamespace() {
		return namespace;
	}

	public String getPrefix() {
		return prefix;
	}
	
	@Override
	public String toString() {
		return getNamespace();
	}
}
