package de.brightbyte.rdf.vocab;

import de.brightbyte.rdf.RdfException;
import de.brightbyte.rdf.RdfPlatform;
import de.brightbyte.rdf.RdfNamespace;

/**
 * SKOS vocabulary, as defined by http://www.w3.org/TR/skos-reference/
 */
public class SKOS<V, R extends V> implements RdfNamespace<V, R> {
	public static final String namespace = "http://www.w3.org/2004/02/skos/core#";
	
	public final String prefix;
	
	public final R Concept;
	public final R ConceptScheme;
	
	public final R LabelRelation;
	public final R Collection;
	public final R OrderedCollection;

	public final R inScheme;
	public final R hasTopConcept;
	
	public final R prefLabel;
	public final R altLabel;
	public final R hiddenLabel;

	public final R note;
	public final R changeNote;
	public final R editorialNote;
	public final R historyNote;
	public final R scopeNote;

	public final R definition;
	public final R example;
	
	public final R semanticRelation;
	public final R broader;
	public final R narrower;
	public final R related;
	
	public final R member;
	public final R memberList;

	public final R broaderTransitive;
	public final R narrowerTransitive;

	public final R label;
	public final R labelRelated;
	public final R seeLabelRelation;

	public final R mappingRelation;
	public final R broaderMatch;
	public final R narrowerMatch;
	public final R relatedMatch;
	public final R exactMatch;

	public SKOS(RdfPlatform<V, R, ?, ?> platform) throws RdfException {
		this(platform, "skos");
	}
	
	public SKOS(RdfPlatform<V, R, ?, ?> platform, String prefix) throws RdfException {
		
		this.prefix = prefix;
		
		Concept = platform.newResource(namespace, "Concept");
		ConceptScheme = platform.newResource(namespace, "ConceptScheme");
		
		LabelRelation = platform.newResource(namespace, "LabelRelation");
		Collection = platform.newResource(namespace, "Collection");
		OrderedCollection = platform.newResource(namespace, "OrderedCollection");

		inScheme = platform.newResource(namespace, "inScheme");
		hasTopConcept = platform.newResource(namespace, "hasTopConcept");
		
		prefLabel = platform.newResource(namespace, "prefLabel");
		altLabel = platform.newResource(namespace, "altLabel");
		hiddenLabel = platform.newResource(namespace, "hiddenLabel");

		note = platform.newResource(namespace, "note");
		changeNote = platform.newResource(namespace, "changeNote");
		editorialNote = platform.newResource(namespace, "editorialNote");
		historyNote = platform.newResource(namespace, "historyNote");
		scopeNote = platform.newResource(namespace, "scopeNote");

		definition = platform.newResource(namespace, "definition");
		example = platform.newResource(namespace, "example");
		
		semanticRelation = platform.newResource(namespace, "semanticRelation");
		broader = platform.newResource(namespace, "broader");
		narrower = platform.newResource(namespace, "narrower");
		related = platform.newResource(namespace, "related");
		
		member = platform.newResource(namespace, "member");
		memberList = platform.newResource(namespace, "memberList");

		broaderTransitive = platform.newResource(namespace, "broaderTransitive");
		narrowerTransitive = platform.newResource(namespace, "narrowerTransitive");

		label = platform.newResource(namespace, "label");
		labelRelated = platform.newResource(namespace, "labelRelated");
		seeLabelRelation = platform.newResource(namespace, "seeLabelRelation");

		mappingRelation = platform.newResource(namespace, "mappingRelation");
		broaderMatch = platform.newResource(namespace, "broaderMatch");
		narrowerMatch = platform.newResource(namespace, "narrowerMatch");
		relatedMatch = platform.newResource(namespace, "relatedMatch");
		exactMatch = platform.newResource(namespace, "exactMatch");
	}

	public String getNamespace() {
		return namespace;
	}

	public String getPrefix() {
		return prefix;
	}
	
	@Override
	public String toString() {
		return getNamespace();
	}
}
